
#IFDEF __STORY_DEBUG__
	Print _ConstEngine_ & " DevKit " & _ConstBuild_ & " Core / VGA Lookup"
	SimpleWait ( )
#ENDIF

ReDim Shared As String VGA_Table ( -1 To -1 )

Declare Sub VGA_Load ( VGA_Table ( Any ) As String, Gamepack As Gamepack_Main_Type )

Declare Function VGA_Lookup ( Index As Integer = 0 ) As uLongInt

Sub VGA_Load ( VGA_Table ( Any ) As String, Gamepack As Gamepack_Main_Type )
	
	Erase VGA_Table
	ReDim VGA_Table ( -1 To -1 )
	
	Dim As String ReserveBuffer, OutBuffer

	If Not Is_File ( _ConstIncPathStr_ & Gamepack.Root & Gamepack.Pack & "\Assets\" & Gamepack.pal ) Then
		Exit Sub
	End If

	Dim As Long FileMode = FreeFile

	If FileMode = 0 Then
		Close #FileMode
		Exit Sub
	End If

	IF Open ( _ConstIncPathStr_ & Gamepack.Root & Gamepack.Pack & "\Assets\" & Gamepack.pal For Binary As #FileMode ) Then
		Close #FileMode
		FileMode = 0
		Exit Sub
	End If

	ReserveBuffer = Space ( Lof ( Filemode ) )
	Get #Filemode, 1, ReserveBuffer
	Close #Filemode
	
	Do While Len ( ReserveBuffer ) > 0
		
		OutBuffer = Prefix ( CRLF, ReserveBuffer )
		ReserveBuffer = Suffix ( CRLF, ReserveBuffer )
		ReDim Preserve VGA_Table ( 0 To UBound ( VGA_Table ) + 1 )
		VGA_Table ( UBound ( VGA_Table, 1 ) ) = Trim ( OutBuffer, QUOT )
	
	Loop
	
	Exit Sub
	
End Sub

Function VGA_Lookup ( Index As Integer = 0 ) As uLongInt

	Select Case Index

	Case 0 To 255

		VGA_Lookup = ValULng ( VGA_Table ( Index ) )
		Exit Function
		
	Case Else

		VGA_Lookup = ValULng ( VGA_Table ( 0 ) )
		Exit Function

	End Select

End Function

